<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Video\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Options;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

class CompositionSettingsContext extends InstanceContext {
    /**
     * Initialize the CompositionSettingsContext
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(Version $version) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [];

        $this->uri = '/CompositionSettings/Default';
    }

    /**
     * Fetch the CompositionSettingsInstance
     *
     * @return CompositionSettingsInstance Fetched CompositionSettingsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): CompositionSettingsInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new CompositionSettingsInstance($this->version, $payload);
    }

    /**
     * Create the CompositionSettingsInstance
     *
     * @param string $friendlyName A descriptive string that you create to describe
     *                             the resource
     * @param array|Options $options Optional Arguments
     * @return CompositionSettingsInstance Created CompositionSettingsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $friendlyName, array $options = []): CompositionSettingsInstance {
        $options = new Values($options);

        $data = Values::of([
            'FriendlyName' => $friendlyName,
            'AwsCredentialsSid' => $options['awsCredentialsSid'],
            'EncryptionKeySid' => $options['encryptionKeySid'],
            'AwsS3Url' => $options['awsS3Url'],
            'AwsStorageEnabled' => Serialize::booleanToString($options['awsStorageEnabled']),
            'EncryptionEnabled' => Serialize::booleanToString($options['encryptionEnabled']),
        ]);

        $payload = $this->version->create('POST', $this->uri, [], $data);

        return new CompositionSettingsInstance($this->version, $payload);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Video.V1.CompositionSettingsContext ' . \implode(' ', $context) . ']';
    }
}